<?php //include config
require_once('includes/config.php');

//if not logged in redirect to login page
if(!$user->is_logged_in()){ header('Location: login.php'); }

?>
<!DOCTYPE html>
<!--
	This is a starter template page. Use this page to start your new project from
	scratch. This page gets rid of all links and provides the needed markup only.
	-->
<html>
	<head>
		<meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<title>Maintenance Modify Transaction</title>
		<!-- Tell the browser to be responsive to screen width -->
		<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
		<!-- Bootstrap 3.3.5 -->
		<link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
		<!-- Font Awesome -->
		<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
		<!-- Ionicons -->
		<link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
		<!-- DataTables -->
		<link rel="stylesheet" href="plugins/datatables/dataTables.bootstrap.css">
		<!-- Select2 -->
		<link rel="stylesheet" href="plugins/select2/select2.min.css">
		<!-- daterange picker -->
		<link rel="stylesheet" href="plugins/daterangepicker/daterangepicker-bs3.css">
		<!-- iCheck for checkboxes and radio inputs -->
		<link rel="stylesheet" href="plugins/iCheck/all.css">
		<!-- Theme style -->
		<link rel="stylesheet" href="dist/css/AdminLTE.min.css">
		<!-- AdminLTE Skins -->
		<link rel="stylesheet" href="dist/css/skins/skin-blue.min.css">
		<!--[if lt IE 9]>
		<script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
		<script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
		<![endif]-->
		<script language="JavaScript" type="text/javascript">
			function delpost(id)
			{
			 if (confirm("Are you sure you want to delete this entry?"))
			 {
			 	window.location.href = 'edit-maintenance.php?delpost=' + id;
			 }
			}
		</script>
	</head>
	<body class="hold-transition skin-blue sidebar-mini">
		<div class="wrapper">
			<?php include "header.php";?>
			<!-- Content Wrapper. Contains page content -->
			<div class="content-wrapper">
				<!-- Main content -->
				<section class="content">
					<div class="box">
						<div class="box-body">
						<h3>All Maintenances</h3>
						<?php 
							//show message from add / edit page
							if(isset($_GET['action'])){ 
								echo '<div class="callout callout-success"><h3>Entry '.$_GET['action'].'.</h3></div>'; 
							} 
							?>
							<table id="maintenances" class="table table-bordered table-striped">
								<thead>
									<tr>
										<th>Area</th>
										<th>Type</th>
										<th>Date Lodged</th>
										<th>comment</th>
										<th>Action</th>
									</tr>
								</thead>
								<tbody>
									<?php
										try {
										
											$stmt = $db->query("SELECT 
											       m_maintenances.ID,
												   m_areas.area_name,
												   m_categories.category_name,
												   DATE_FORMAT(m_maintenances.date_lodged,'%d %b %Y') as date_lodged,
												   m_maintenances.comment,
												   m_maintenances.activityIDs
												FROM (m_maintenances
													INNER JOIN m_areas
													   ON (m_maintenances.areaID = m_areas.areaID))
												   INNER JOIN m_categories m_categories
													  ON (m_maintenances.categoryID = m_categories.categoryID) 
												ORDER BY m_maintenances.date_lodged DESC");
											#$stmt->execute(array(':actif' => $actif));
											while($row = $stmt->fetch()){
												
												echo '<tr>';
												echo '<td>'.$row['area_name'].'</td>';
												echo '<td>'.$row['category_name'].'</td>';
												echo '<td>'.$row['date_lodged'].'</td>';
												echo '<td>'.$row['comment'].'</td>';
												?>
									<td>
										<div class="visible-lg">
											<a class="btn btn-primary btn-sm" href="edit-maintenance.php?id=<?php echo $row['ID'];?>">Edit Maintenance</a> 
											<a class="btn btn-danger btn-sm" href="javascript:delpost('<?php echo $row['ID'];?>')">Delete</a> 
										</div>
										<div class="visible-md visible-sm visible-xs">
											<a class="btn btn-primary btn-xs" href="edit-maintenance.php?id=<?php echo $row['ID'];?>">Edit Maintenance</a> 
											<a class="btn btn-danger btn-xs" href="javascript:delpost('<?php echo $row['ID'];?>')">Delete</a> 
										</div>
									</td>
									<?php 
										echo '</tr>';
										
										}
										
										} catch(PDOException $e) {
										echo $e->getMessage();
										}
										?>
								</tbody>
								<tfoot>
									<tr>
										<th>Area</th>
										<th>Type</th>
										<th>Date Lodged</th>
										<th>Comment</th>
										<th>Action</th>
									</tr>
								</tfoot>
							</table>
							<a class="btn btn-primary btn-lg" href="add-maintenance.php">Add New</a>
						</div>
					</div>
				</section>
				<!-- /.content -->
			</div>
			<!-- /.content-wrapper -->
			<!-- Main Footer -->
			<?php include "footer.php";?>
		</div>
		<!-- ./wrapper -->
		<!-- REQUIRED JS SCRIPTS -->
		<!-- jQuery 2.2.0 -->
		<script src="plugins/jQuery/jQuery-2.2.0.min.js"></script>
		<script src="//code.jquery.com/ui/1.11.2/jquery-ui.js"></script>
		<!-- Bootstrap 3.3.5 -->
		<script src="bootstrap/js/bootstrap.min.js"></script>
		<!-- Select2 -->
		<script src="plugins/select2/select2.full.min.js"></script>
		<!-- date-range-picker -->
		<script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.10.6/moment.min.js"></script>
		<script src="plugins/daterangepicker/daterangepicker.js"></script>
		<!-- DataTables -->
		<script src="plugins/datatables/jquery.dataTables.min.js"></script>
		<script src="plugins/datatables/dataTables.bootstrap.min.js"></script>
		<!-- SlimScroll -->
		<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
		<!-- FastClick -->
		<script src="plugins/fastclick/fastclick.js"></script>
		<!-- iCheck 1.0.1 -->
		<script src="plugins/iCheck/icheck.min.js"></script>
		<!-- AdminLTE App -->
		<script src="dist/js/app.min.js"></script>
		<script>
			$(function () {
				$('#maintenances').DataTable( {
					order: [[ 2, "desc" ]],
					destroy: true,
					paging: true,
					searching: true
				});
			});
			
		</script>
	</body>
</html>