<?php //include config ''18446744073709551615'' 
require_once('includes/config.php');

//if not logged in redirect to login page
if(!$user->is_logged_in()){ header('Location: login.php'); }

$resident = "";
$limitnumber = 2147483000;

if (isset($_GET['residentID'])) {
	if ($_GET['residentID']<>"") $resident = "AND residents.residentID=".$_GET['residentID'];
}

if (isset($_GET['numberofrecords'])) {
	if ($_GET['numberofrecords']<>"ALL") $limitnumber = (int)$_GET['numberofrecords'];
}

?>
<!DOCTYPE html>
<!--
	This is a starter template page. Use this page to start your new project from
	scratch. This page gets rid of all links and provides the needed markup only.
	-->
<html>
	<head>
		<meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<title>Print Transactions</title>
		<!-- Tell the browser to be responsive to screen width -->
		<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
		<!-- Bootstrap 3.3.5 -->
		<link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
		<!-- Font Awesome -->
		<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
		<!-- Ionicons -->
		<link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
		<!-- DataTables -->
		<link rel="stylesheet" href="plugins/datatables/dataTables.bootstrap.css">
		<!-- Select2 -->
		<link rel="stylesheet" href="plugins/select2/select2.min.css">
		<!-- daterange picker -->
		<link rel="stylesheet" href="plugins/daterangepicker/daterangepicker-bs3.css">
		<!-- iCheck for checkboxes and radio inputs -->
		<link rel="stylesheet" href="plugins/iCheck/all.css">
		<!-- Theme style -->
		<link rel="stylesheet" href="dist/css/AdminLTE.min.css">
		<!-- AdminLTE Skins -->
		<link rel="stylesheet" href="dist/css/skins/skin-blue.min.css">
		<!--[if lt IE 9]>
		<script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
		<script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
		<![endif]-->
		<style type="text/css" media="print">
			@page 
			{
				size: auto;   /* auto is the initial value */
				margin-top: 10mm;  /* this affects the margin in the printer settings */
				margin-bottom: 10mm;  /* this affects the margin in the printer settings */
				
				@bottom-left {
					content: counter(page) "/" counter(pages);
				}			
			}
			
			.main-footer{
				visibility: hidden;
			}
			
			.col-md-2{
				width:150px
			}
			
			.col-md-1{
				width:75px
			}

			#dateselect{
				visibility: hidden;
				height: 0px;
			}
		</style>
	</head>
	<body class="hold-transition skin-blue sidebar-mini">
		<div class="wrapper">
			<?php include "header.php";?>
			<!-- Modal -->
			<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
			  <div class="modal-dialog" role="document">
				<div class="modal-content">
				  <div class="modal-header">
					<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					<h4 class="modal-title" id="myModalLabel">Select Resident</h4>
				  </div>
				  <div class="modal-body">
					  <div class="box box-primary">
						<div class="box-header with-border">
						  <h3 class="box-title">Resident</h3>
						</div>
						<form id="myForm" role="form">
						  <div class="box-body">
								<div class="form-group">
									<select id="residentID" name="residentID" class="form-control Location" style="width: 100%;">
									  <option></option>
									<?php
										$stmt2 = $db->query('SELECT residents.residentID, residents.first_name, residents.last_name FROM residents ORDER BY residents.first_name, residents.last_name');
										while($row2 = $stmt2->fetch()){
											print "<option value=" . $row2['residentID'] . ">" . $row2['first_name']." ". $row2['last_name'] . "</option>\n";
										}
									?>
									</select>
								</div>
								<div class="form-group">
									<label>Number of records</label>
									<select id="numberofrecords" name="numberofrecords" class="form-control Location" style="width: 100%;">
  									  <option>ALL</option>
									  <option>10</option>
									  <option>20</option>
									  <option>30</option>
									  <option>40</option>
									  <option>50</option>
									</select>
								</div>
						  </div>
						</form>
					  </div>
				  </div>
					<div class="modal-footer">
						<button class="btn" data-dismiss="modal" aria-hidden="true">Close</button>
						<button class="btn btn-primary odom-submit">Continue</button>
					</div>    
				</div>
			  </div>
			</div>
			<!-- Content Wrapper. Contains page content -->
			<div class="content-wrapper">
				<!-- Main content -->
				<section class="content">
					<div class="box">
						<div class="box-body">
						<?php if ($resident == "") echo "<h2>All Transactions per Residents</h2>";?>
						
						<a id="dateselect" class="btn btn-primary" href="#" data-toggle="modal" data-target="#myModal" style="margin-bottom: 20px;">Filter Resident</a>
						<?php
						$stmt1 = $db->query("SELECT distinct residents.residentID, residents.first_name, residents.last_name, residents.balance FROM residents WHERE residents.balance <>0 $resident ORDER BY residents.first_name, residents.last_name");
						#$stmt->execute(array(':actif' => $actif));
						while($grouprow = $stmt1->fetch()){
						
						?>
						<div class="row">
						<div class="col-md-3"><h3><?php echo $grouprow['first_name']." ". $grouprow['last_name'];?></h3></div>
						<div class="col-md-9"><h4>Balance: $<?php echo $grouprow['balance'];?></h4></div>
						</div>
						
							<table class="table table-bordered table-striped">
								<thead>
									<tr>
										<th>Date</th>
										<th>Comment</th>
										<th class="col-md-1 text-right">Amount</th>
									</tr>
								</thead>
								<tbody>
									<?php
									$residentID = $grouprow['residentID'];
									$limitnumber = (int)$limitnumber;
									
									$stmt = $db->prepare("SELECT amount,comment,date FROM transactions 
										WHERE residentID=:residentID ORDER BY date DESC LIMIT :limit");
									$stmt->bindParam(':residentID', $residentID, PDO::PARAM_INT);
									$stmt->bindParam(':limit', $limitnumber, PDO::PARAM_INT);
									$stmt->execute();
									
									while($row = $stmt->fetch()){
										
										echo '<tr>';
										echo '<td class="col-md-2">'.$row['date'].'</td>';
										echo '<td class="col-md-9">'.$row['comment'].'</td>';
										echo '<td class="col-md-1 text-right">'.$row['amount'].'</td>';
										echo '</tr>';
									}
									?>
								</tbody>
							</table>
						<?php }?>
						</div>
					</div>
				</section>
				<!-- /.content -->
				<section class="content-header">
					<a class="btn btn-default" href="javascript: this.print();">​​​​​​​​​​​​​​​​​print</a>
				</section>
			</div>
			<!-- /.content-wrapper -->
			<!-- Main Footer -->
			<?php include "footer.php";?>
		</div>
		<!-- ./wrapper -->
		<!-- REQUIRED JS SCRIPTS -->
		<!-- jQuery 2.2.0 -->
		<script src="plugins/jQuery/jQuery-2.2.0.min.js"></script>
		<script src="//code.jquery.com/ui/1.11.2/jquery-ui.js"></script>
		<!-- Bootstrap 3.3.5 -->
		<script src="bootstrap/js/bootstrap.min.js"></script>
		<!-- Select2 -->
		<script src="plugins/select2/select2.full.min.js"></script>
		<!-- date-range-picker -->
		<script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.10.6/moment.min.js"></script>
		<script src="plugins/daterangepicker/daterangepicker.js"></script>
		<!-- DataTables -->
		<script src="plugins/datatables/jquery.dataTables.min.js"></script>
		<script src="plugins/datatables/dataTables.bootstrap.min.js"></script>
		<!-- SlimScroll -->
		<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
		<!-- FastClick -->
		<script src="plugins/fastclick/fastclick.js"></script>
		<!-- iCheck 1.0.1 -->
		<script src="plugins/iCheck/icheck.min.js"></script>
		<!-- AdminLTE App -->
		<script src="dist/js/app.min.js"></script>
		<script>
			$(function () {
				//Initialize Select2 Elements
				$("#residentID").select2({
				  placeholder: "Select a Resident",
				  allowClear: true
				});

				$('body').on('click', '.odom-submit', function (e) {
					$(this.form).submit();
					$('#myModal').modal('hide');
					window.location.replace("resident-print-transactions.php?residentID=" + document.getElementById('residentID').value + "&numberofrecords=" + document.getElementById('numberofrecords').value);
				});
				$('#myModal').on('shown.bs.modal', function(e) {
					$('#myInput').focus()
				});
			});
			$('#dates').daterangepicker({
				showDropdowns: true,
				locale: {
					"format": "DD MMM YYYY",
					"firstDay": 1
				},
			});
		</script>
	</body>
</html>