<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);


try {

	//find resident's details
	$stmt = $db->prepare('SELECT username FROM users WHERE userID = :userID') ;
	$stmt->execute(array(':userID' => isset($_SESSION['userID'])));
	$row = $stmt->fetch(); 

} catch(PDOException $e) {
	echo $e->getMessage();
}

?>
  <!-- Main Header -->
  <header class="main-header">

    <!-- Logo -->
    <a href="index.php" class="logo">
      <!-- mini logo for sidebar mini 50x50 pixels -->
      <span class="logo-mini"><b>P</b>C</span>
      <!-- logo for regular state and mobile devices -->
      <span class="logo-lg"><b>Petty</b> Cash</span>
    </a>

    <!-- Header Navbar -->
    <nav class="navbar navbar-static-top" role="navigation">

      <!-- Sidebar toggle button-->
      <a href="#" class="sidebar-toggle" data-toggle="offcanvas" role="button">
        <span class="sr-only">Toggle navigation</span>
      </a>

      <!-- Navbar Right Menu -->
      <div class="navbar-custom-menu">
        <ul class="nav navbar-nav">
          <!-- User Account Menu -->
          <li class="dropdown user user-menu">

            <!-- Menu Toggle Button -->
            <a href="#" class="dropdown-toggle" data-toggle="dropdown">
              <!-- The user image in the navbar-->
              <img src="dist/img/avatar6.png" class="user-image" alt="User Image">
              <!-- hidden-xs hides the username on small devices so only the image appears. -->
              <span class="hidden-xs"><?php echo $row['username'];?></span>
            </a>
            <ul class="dropdown-menu">
              <!-- The user image in the menu -->
              <li class="user-header">
                <img src="dist/img/avatar6.png" class="img-circle" alt="User Image">
				<p>Administrator <small>All permissions</small></p>
			  </li>
              <!-- Menu Footer-->
              <li class="user-footer">
                 <div class="pull-right">
                  <a href="logout.php" class="btn btn-default btn-flat">Sign out</a>
                </div>
              </li>
            </ul>
          </li>
          <!-- Control Sidebar Toggle Button -->
        </ul>
      </div>
    </nav>
  </header>
  <!-- Left side column. contains the logo and sidebar -->
  <aside class="main-sidebar">

    <!-- sidebar: style can be found in sidebar.less -->
    <section class="sidebar">

      <!-- Sidebar Menu -->
      <ul class="sidebar-menu">
        <li class="header">MENU</li>
        <!-- Optionally, you can add icons to the links -->
        <li class="treeview">
          <a href="#"><i class="fa fa-address-book"></i> <span>Residents</span> <i class="fa fa-angle-left pull-right"></i></a>
          <ul class="treeview-menu">
            <li><a href="index.php">List</a></li>
            <li><a href="index.php?actif=0">Show Inactive</a></li>
            <li><a href="add-resident.php">Add New</a></li>
            <li><a href="javascript: w=window.open('residentsprint.php'); w.print();">​​​​​​​​​​​​​​​​​print</a></li>
          </ul>
        </li>
        <li class="treeview">
          <a href="#"><i class="fa fa-usd"></i> <span>Transactions</span> <i class="fa fa-angle-left pull-right"></i></a>
          <ul class="treeview-menu">
            <li><a href="transactions.php">List</a></li>
            <li><a href="add-transaction.php?action=add">Add Money</a></li>
            <li><a href="add-transaction.php?action=use">Use Money</a></li>
          </ul>
        </li>
        <li class="treeview">
          <a href="#"><i class="fa fa-users"></i> <span>Users</span> <i class="fa fa-angle-left pull-right"></i></a>
          <ul class="treeview-menu">
            <li><a href="users.php">List</a></li>
            <li><a href="add-user.php">Add New</a></li>
          </ul>
        </li>
      <!-- /.sidebar-menu -->
		<li class="header">
			<h4 style="color:#B8C7CE">Balances</h4>
			<?php
			//find Reception's balance
			$stmt = $db->prepare('SELECT balance FROM residents WHERE residentID = :residentID') ;
			$stmt->execute(array(':residentID' => 0));
			$row = $stmt->fetch(); 
			$reception_balance=$row['balance'];

			//find Banks's balance
			$stmt = $db->prepare('SELECT balance FROM residents WHERE residentID = :residentID') ;
			$stmt->execute(array(':residentID' => 1));
			$row = $stmt->fetch(); 
			$bank_balance=$row['balance'];
			?>
			<ul class="list-group">
				<li class="list-group-item">Bank <span class="pull-right">$<?php echo $bank_balance;?></span></li>
				<li class="list-group-item">Reception <span class="pull-right">$<?php echo $reception_balance;?></span></li>
				<li class="list-group-item"><strong>Total <span class="pull-right">$<?php echo number_format($bank_balance+$reception_balance,2,'.',"'");?></span></strong></li>
			</ul>
		</li>
      </ul>

    </section>
    <!-- /.sidebar -->
  </aside>

