<?php
	//include config
	require_once('includes/config.php');
	
	//if not logged in redirect to login page
	if(!$user->is_logged_in()){ header('Location: login.php'); }


	?>
<!DOCTYPE html>
<!--
	This is a starter template page. Use this page to start your new project from
	scratch. This page gets rid of all links and provides the needed markup only.
	-->
<html>
	<head>
		<meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<title>Petty Cash</title>
		<!-- Tell the browser to be responsive to screen width -->
		<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
		<!-- Bootstrap 3.3.5 -->
		<link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
		<!-- Font Awesome -->
		<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
		<!-- Ionicons -->
		<link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
		<!-- DataTables -->
		<link rel="stylesheet" href="plugins/datatables/dataTables.bootstrap.css">
		<!-- Theme style -->
		<link rel="stylesheet" href="dist/css/AdminLTE.min.css">
		<!-- AdminLTE Skins -->
		<link rel="stylesheet" href="dist/css/skins/skin-blue.min.css">
		<!--[if lt IE 9]>
		<script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
		<script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
		<![endif]-->
	</head>
	<body class="hold-transition skin-blue sidebar-mini">
		<div class="wrapper">
			<?php include "header.php";?>
			<!-- Content Wrapper. Contains page content -->
			<div class="content-wrapper">
			<?php
			if(isset($_GET['id'])){
				try {

					//find resident's details
					$stmt = $db->prepare('SELECT residentID, first_name, last_name, room_number, balance FROM residents WHERE residentID = :residentID') ;
					$stmt->execute(array(':residentID' => $_GET['id']));
					$row = $stmt->fetch(); 

			?>
				<!-- Content Header (Page header) -->
				<section class="content-header">
					<h1>
						<?php echo "Transactions for ".$row['first_name']." ".$row['last_name']." - Room# ".$row['room_number'];?>
					</h1>
					<?php
					if ($row['balance']==abs($row['balance'])){
						echo "<div class='callout callout-success'><h3>Balance: $".$row['balance']."</h3></div>";
					} else {
						echo "<div class='callout callout-danger'><h3>Balance: $".$row['balance']."</h3></div>";
					}
					?>
					
					<ol class="breadcrumb">
						<li><a href="index.php"><i class="fa fa-dashboard"></i> Home</a></li>
					</ol>
				</section>
				<!-- Main content -->
				<section class="content">
					<div class="box">
						<!-- /.box-header -->
						<div class="box-body">
							<table id="residents" class="table table-bordered table-striped">
								<thead>
									<tr>
										<th>Date</th>
										<th>Comment</th>
										<th>Amount</th>
									</tr>
								</thead>
								<tbody>
									<?php
										try {
										
											$stmt = $db->query('SELECT amount,comment,date FROM transactions WHERE residentID='.$_GET['id'].' order by date desc');
											while($row = $stmt->fetch()){
												
												echo '<tr>';
												echo '<td>'.$row['date'].'</td>';
												echo '<td>'.$row['comment'].'</td>';
												if ($row['amount']<0){
													echo '<td style="color:red;"> $'.$row['amount'].'</td>';
												}else{
													echo '<td> $'.$row['amount'].'</td>';
												}

												echo '</tr>';
										
											}
										
										} catch(PDOException $e) {
										echo $e->getMessage();
										}
										?>
								</tbody>
								<tfoot>
									<tr>
										<th>Date</th>
										<th>Comment</th>
										<th>Amount</th>
									</tr>
								</tfoot>
							</table>
						</div>
					</div>
				</section>
			<?php
				} catch(PDOException $e) {
					echo $e->getMessage();
				}
			} else {
			?>
				<!-- Content Header (Page header) -->
				<section class="content-header">
					<h1>
						Transactions for ALL Users
					</h1>
					<ol class="breadcrumb">
						<li><a href="index.php"><i class="fa fa-dashboard"></i> Home</a></li>
					</ol>
				</section>
				<!-- Main content -->
				<section class="content">
					<div class="box">
						<!-- /.box-header -->
						<div class="box-body">
							<table id="residents" class="table table-bordered table-striped">
								<thead>
									<tr>
										<th>Date</th>
										<th>Resident</th>
										<th>Comment</th>
										<th>Amount</th>
									</tr>
								</thead>
								<tbody>
									<?php
										try {
										
											$stmt = $db->query('SELECT transactions.residentID,first_name,last_name,amount,transactions.comment,date FROM transactions,residents WHERE transactions.residentID=residents.residentID order by date desc');
											while($row = $stmt->fetch()){
												
												echo '<tr>';
												echo '<td>'.$row['date'].'</td>';
												echo '<td><a href="transactions.php?id='.$row['residentID'].'">'.$row['first_name'].' '.$row['last_name'].'</a></td>';
												echo '<td>'.$row['comment'].'</td>';
												if ($row['amount']<0){
													echo '<td style="color:red;"> $'.$row['amount'].'</td>';
												}else{
													echo '<td> $'.$row['amount'].'</td>';
												}

												echo '</tr>';
										
											}
										
										} catch(PDOException $e) {
										echo $e->getMessage();
										}
										?>
								</tbody>
								<tfoot>
									<tr>
										<th>Date</th>
										<th>Resident</th>
										<th>Comment</th>
										<th>Amount</th>
									</tr>
								</tfoot>
							</table>
						</div>
					</div>
				</section>
			
			<?php }?>
				<!-- /.content -->
			</div>
			<!-- /.content-wrapper -->
			<!-- Main Footer -->
			<?php include "footer.php";?>
		</div>
		<!-- ./wrapper -->
		<!-- REQUIRED JS SCRIPTS -->
		<!-- jQuery 2.2.0 -->
		<script src="plugins/jQuery/jQuery-2.2.0.min.js"></script>
		<script src="//code.jquery.com/ui/1.11.2/jquery-ui.js"></script>
		<!-- Bootstrap 3.3.5 -->
		<script src="bootstrap/js/bootstrap.min.js"></script>
		<!-- DataTables -->
		<script src="plugins/datatables/jquery.dataTables.min.js"></script>
		<script src="plugins/datatables/dataTables.bootstrap.min.js"></script>
		<!-- SlimScroll -->
		<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
		<!-- FastClick -->
		<script src="plugins/fastclick/fastclick.js"></script>
		<!-- AdminLTE App -->
		<script src="dist/js/app.min.js"></script>
		<script>
			$(function () {
			    $('#residents').DataTable( {
				"order": [[ 0, "desc" ]]
			} );
			});
		</script>
	</body>
</html>